/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteAsyncJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ExecuteAsyncJobCmd.class);
    protected JobEntity job;

    public ExecuteAsyncJobCmd(JobEntity job) {
        this.job = job;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.job == null) {
            throw new ActivitiIllegalArgumentException("job is null");
        }
        JobEntity refetchedJob = commandContext.getJobEntityManager().findJobById(this.job.getId());
        if (refetchedJob == null) {
            log.debug("Job does not exist anymore and will not be executed. It has most likely been deleted as part of another concurrent part of the process instance.");
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Executing async job {}", (Object)refetchedJob.getId());
        }
        refetchedJob.execute(commandContext);
        if (commandContext.getEventDispatcher().isEnabled()) {
            commandContext.getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_EXECUTION_SUCCESS, refetchedJob));
        }
        return null;
    }
}

