/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.cmd;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.ActivitiObjectNotFoundException;
import org.activiti5.engine.impl.interceptor.Command;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti5.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.activiti5.engine.runtime.Execution;

public class SignalEventReceivedCmd
implements Command<Void> {
    protected final String eventName;
    protected final String executionId;
    protected final Serializable payload;
    protected final boolean async;
    protected String tenantId;

    public SignalEventReceivedCmd(String eventName, String executionId, Map<String, Object> processVariables, String tenantId) {
        this.eventName = eventName;
        this.executionId = executionId;
        this.payload = processVariables != null ? (processVariables instanceof Serializable ? (Serializable)((Object)processVariables) : new HashMap<String, Object>(processVariables)) : null;
        this.async = false;
        this.tenantId = tenantId;
    }

    public SignalEventReceivedCmd(String eventName, String executionId, boolean async, String tenantId) {
        this.eventName = eventName;
        this.executionId = executionId;
        this.async = async;
        this.payload = null;
        this.tenantId = tenantId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        List<SignalEventSubscriptionEntity> signalEvents = null;
        if (this.executionId == null) {
            signalEvents = commandContext.getEventSubscriptionEntityManager().findSignalEventSubscriptionsByEventName(this.eventName, this.tenantId);
        } else {
            ExecutionEntity execution = commandContext.getExecutionEntityManager().findExecutionById(this.executionId);
            if (execution == null) {
                throw new ActivitiObjectNotFoundException("Cannot find execution with id '" + this.executionId + "'", Execution.class);
            }
            if (execution.isSuspended()) {
                throw new ActivitiException("Cannot throw signal event '" + this.eventName + "' because execution '" + this.executionId + "' is suspended");
            }
            signalEvents = commandContext.getEventSubscriptionEntityManager().findSignalEventSubscriptionsByNameAndExecution(this.eventName, this.executionId);
            if (signalEvents.isEmpty()) {
                throw new ActivitiException("Execution '" + this.executionId + "' has not subscribed to a signal event with name '" + this.eventName + "'.");
            }
        }
        for (SignalEventSubscriptionEntity signalEventSubscriptionEntity : signalEvents) {
            if (!signalEventSubscriptionEntity.isGlobalScoped()) continue;
            signalEventSubscriptionEntity.eventReceived(this.payload, this.async);
        }
        return null;
    }
}

