/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.jobexecutor;

import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Job;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.impl.cmd.StartProcessInstanceCmd;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.jobexecutor.JobHandler;
import org.activiti5.engine.impl.jobexecutor.TimerEventHandler;
import org.activiti5.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti5.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti5.engine.impl.pvm.process.ActivityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerStartEventJobHandler
extends TimerEventHandler
implements JobHandler {
    private static Logger log = LoggerFactory.getLogger(TimerStartEventJobHandler.class);
    public static final String TYPE = "timer-start-event";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(Job job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        DeploymentManager deploymentManager = Context.getProcessEngineConfiguration().getDeploymentManager();
        if (TimerEventHandler.hasRealActivityId(configuration)) {
            this.startProcessInstanceWithInitialActivity(job, configuration, deploymentManager, commandContext);
        } else {
            this.startProcessDefinitionByKey(job, configuration, deploymentManager, commandContext);
        }
    }

    protected void startProcessInstanceWithInitialActivity(Job job, String configuration, DeploymentManager deploymentManager, CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)deploymentManager.findDeployedProcessDefinitionById(job.getProcessDefinitionId());
        String activityId = TimerStartEventJobHandler.getActivityIdFromConfiguration(configuration);
        ActivityImpl startActivity = processDefinition.findActivity(activityId);
        if (!deploymentManager.isProcessDefinitionSuspended(processDefinition.getId())) {
            this.dispatchTimerFiredEvent(job, commandContext);
            ExecutionEntity processInstance = processDefinition.createProcessInstance(null, startActivity);
            processInstance.start();
        } else {
            log.debug("Ignoring timer of suspended process definition {}", (Object)processDefinition.getId());
        }
    }

    protected void startProcessDefinitionByKey(Job job, String configuration, DeploymentManager deploymentManager, CommandContext commandContext) {
        String processDefinitionKey = TimerEventHandler.getActivityIdFromConfiguration(configuration);
        ProcessDefinition processDefinition = null;
        processDefinition = job.getTenantId() == null || "".equals(job.getTenantId()) ? deploymentManager.findDeployedLatestProcessDefinitionByKey(processDefinitionKey) : deploymentManager.findDeployedLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, job.getTenantId());
        if (processDefinition == null) {
            throw new ActivitiException("Could not find process definition needed for timer start event");
        }
        try {
            if (!deploymentManager.isProcessDefinitionSuspended(processDefinition.getId())) {
                this.dispatchTimerFiredEvent(job, commandContext);
                new StartProcessInstanceCmd(processDefinitionKey, null, null, null, job.getTenantId()).execute(commandContext);
            } else {
                log.debug("Ignoring timer of suspended process definition {}", (Object)processDefinition.getId());
            }
        }
        catch (RuntimeException e) {
            log.error("exception during timer execution", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("exception during timer execution", (Throwable)e);
            throw new ActivitiException("exception during timer execution: " + e.getMessage(), e);
        }
    }

    protected void dispatchTimerFiredEvent(Job job, CommandContext commandContext) {
        if (commandContext.getEventDispatcher().isEnabled()) {
            commandContext.getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TIMER_FIRED, job));
        }
    }
}

