/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl;

import org.activiti.dmn.api.DmnRepositoryService;
import org.activiti.dmn.api.DmnRuleService;
import org.activiti.dmn.engine.DmnEngine;
import org.activiti.dmn.engine.DmnEngineConfiguration;
import org.activiti.dmn.engine.DmnEngines;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnEngineImpl
implements DmnEngine {
    private static Logger log = LoggerFactory.getLogger(DmnEngineImpl.class);
    protected String name;
    protected DmnRepositoryService dmnRepositoryService;
    protected DmnRuleService dmnRuleService;
    protected DmnEngineConfiguration dmnEngineConfiguration;

    public DmnEngineImpl(DmnEngineConfiguration dmnEngineConfiguration) {
        this.dmnEngineConfiguration = dmnEngineConfiguration;
        this.name = dmnEngineConfiguration.getDmnEngineName();
        this.dmnRepositoryService = dmnEngineConfiguration.getDmnRepositoryService();
        this.dmnRuleService = dmnEngineConfiguration.getDmnRuleService();
        if (this.name == null) {
            log.info("default activiti DmnEngine created");
        } else {
            log.info("DmnEngine {} created", (Object)this.name);
        }
        DmnEngines.registerDmnEngine(this);
    }

    @Override
    public void close() {
        DmnEngines.unregister(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DmnRepositoryService getDmnRepositoryService() {
        return this.dmnRepositoryService;
    }

    @Override
    public DmnRuleService getDmnRuleService() {
        return this.dmnRuleService;
    }

    @Override
    public DmnEngineConfiguration getDmnEngineConfiguration() {
        return this.dmnEngineConfiguration;
    }
}

