/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl.cmd;

import org.activiti.dmn.engine.ActivitiDmnIllegalArgumentException;
import org.activiti.dmn.engine.ActivitiDmnObjectNotFoundException;
import org.activiti.dmn.engine.impl.interceptor.Command;
import org.activiti.dmn.engine.impl.interceptor.CommandContext;
import org.activiti.dmn.engine.impl.persistence.deploy.DecisionTableCacheEntry;
import org.activiti.dmn.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.dmn.engine.impl.persistence.entity.DecisionTableEntity;

public class SetDecisionTableCategoryCmd
implements Command<Void> {
    protected String decisionTableId;
    protected String category;

    public SetDecisionTableCategoryCmd(String decisionTableId, String category) {
        this.decisionTableId = decisionTableId;
        this.category = category;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.decisionTableId == null) {
            throw new ActivitiDmnIllegalArgumentException("Decision table id is null");
        }
        DecisionTableEntity decisionTable = (DecisionTableEntity)commandContext.getDecisionTableEntityManager().findById(this.decisionTableId);
        if (decisionTable == null) {
            throw new ActivitiDmnObjectNotFoundException("No decision table found for id = '" + this.decisionTableId + "'");
        }
        decisionTable.setCategory(this.category);
        DeploymentCache<DecisionTableCacheEntry> decisionTableCache = commandContext.getDmnEngineConfiguration().getDecisionCache();
        if (decisionTableCache != null) {
            decisionTableCache.remove(this.decisionTableId);
        }
        commandContext.getDecisionTableEntityManager().update(decisionTable);
        return null;
    }

    public String getDecisionTableId() {
        return this.decisionTableId;
    }

    public void setDecisionTableId(String decisionTableId) {
        this.decisionTableId = decisionTableId;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

