/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.ldap;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.identity.Group;
import org.activiti.engine.runtime.ClockReader;

public class LDAPGroupCache {
    private final ClockReader clockReader;
    protected Map<String, LDAPGroupCacheEntry> groupCache;
    protected long expirationTime;
    protected LDAPGroupCacheListener ldapCacheListener;

    public LDAPGroupCache(final int cacheSize, long expirationTime, ClockReader clockReader) {
        this.clockReader = clockReader;
        this.groupCache = new LinkedHashMap<String, LDAPGroupCacheEntry>(cacheSize + 1, 0.75f, true){
            private static final long serialVersionUID = 5207574193173514579L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, LDAPGroupCacheEntry> eldest) {
                boolean removeEldest;
                boolean bl = removeEldest = this.size() > cacheSize;
                if (removeEldest && LDAPGroupCache.this.ldapCacheListener != null) {
                    LDAPGroupCache.this.ldapCacheListener.cacheEviction(eldest.getKey());
                }
                return removeEldest;
            }
        };
        this.expirationTime = expirationTime;
    }

    public void add(String userId, List<Group> groups) {
        this.groupCache.put(userId, new LDAPGroupCacheEntry(this.clockReader.getCurrentTime(), groups));
    }

    public List<Group> get(String userId) {
        LDAPGroupCacheEntry cacheEntry = this.groupCache.get(userId);
        if (cacheEntry != null) {
            if (this.clockReader.getCurrentTime().getTime() - cacheEntry.getTimestamp().getTime() < this.expirationTime) {
                if (this.ldapCacheListener != null) {
                    this.ldapCacheListener.cacheHit(userId);
                }
                return cacheEntry.getGroups();
            }
            this.groupCache.remove(userId);
            if (this.ldapCacheListener != null) {
                this.ldapCacheListener.cacheExpired(userId);
                this.ldapCacheListener.cacheEviction(userId);
            }
        }
        if (this.ldapCacheListener != null) {
            this.ldapCacheListener.cacheMiss(userId);
        }
        return null;
    }

    public void clear() {
        this.groupCache.clear();
    }

    public Map<String, LDAPGroupCacheEntry> getGroupCache() {
        return this.groupCache;
    }

    public void setGroupCache(Map<String, LDAPGroupCacheEntry> groupCache) {
        this.groupCache = groupCache;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public LDAPGroupCacheListener getLdapCacheListener() {
        return this.ldapCacheListener;
    }

    public void setLdapCacheListener(LDAPGroupCacheListener ldapCacheListener) {
        this.ldapCacheListener = ldapCacheListener;
    }

    public static interface LDAPGroupCacheListener {
        public void cacheHit(String var1);

        public void cacheMiss(String var1);

        public void cacheEviction(String var1);

        public void cacheExpired(String var1);
    }

    static class LDAPGroupCacheEntry {
        protected Date timestamp;
        protected List<Group> groups;

        public LDAPGroupCacheEntry() {
        }

        public LDAPGroupCacheEntry(Date timestamp, List<Group> groups) {
            this.timestamp = timestamp;
            this.groups = groups;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }

        public List<Group> getGroups() {
            return this.groups;
        }

        public void setGroups(List<Group> groups) {
            this.groups = groups;
        }
    }
}

