/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.cmd.JobType;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.AbstractJobEntity;
import org.activiti.engine.runtime.Job;

public class GetJobExceptionStacktraceCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String jobId;
    protected JobType jobType;

    public GetJobExceptionStacktraceCmd(String jobId, JobType jobType) {
        this.jobId = jobId;
        this.jobType = jobType;
    }

    @Override
    public String execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new ActivitiIllegalArgumentException("jobId is null");
        }
        AbstractJobEntity job = null;
        switch (this.jobType) {
            case ASYNC: {
                job = (AbstractJobEntity)commandContext.getJobEntityManager().findById(this.jobId);
                break;
            }
            case TIMER: {
                job = (AbstractJobEntity)commandContext.getTimerJobEntityManager().findById(this.jobId);
                break;
            }
            case SUSPENDED: {
                job = (AbstractJobEntity)commandContext.getSuspendedJobEntityManager().findById(this.jobId);
                break;
            }
            case DEADLETTER: {
                job = (AbstractJobEntity)commandContext.getDeadLetterJobEntityManager().findById(this.jobId);
            }
        }
        if (job == null) {
            throw new ActivitiObjectNotFoundException("No job found with id " + this.jobId, Job.class);
        }
        return job.getExceptionStacktrace();
    }
}

