/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.ExecutionQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.ProcessInstanceQueryImpl;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.persistence.CountingExecutionEntity;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.DeadLetterJobEntity;
import org.activiti.engine.impl.persistence.entity.DeadLetterJobEntityManager;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntityManager;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.JobEntityManager;
import org.activiti.engine.impl.persistence.entity.SuspendedJobEntity;
import org.activiti.engine.impl.persistence.entity.SuspendedJobEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.activiti.engine.impl.persistence.entity.TimerJobEntity;
import org.activiti.engine.impl.persistence.entity.TimerJobEntityManager;
import org.activiti.engine.impl.persistence.entity.VariableInstance;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntityManager;
import org.activiti.engine.impl.persistence.entity.data.DataManager;
import org.activiti.engine.impl.persistence.entity.data.ExecutionDataManager;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionEntityManagerImpl
extends AbstractEntityManager<ExecutionEntity>
implements ExecutionEntityManager {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionEntityManagerImpl.class);
    protected ExecutionDataManager executionDataManager;

    public ExecutionEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, ExecutionDataManager executionDataManager) {
        super(processEngineConfiguration);
        this.executionDataManager = executionDataManager;
    }

    @Override
    protected DataManager<ExecutionEntity> getDataManager() {
        return this.executionDataManager;
    }

    @Override
    public void delete(ExecutionEntity entity) {
        this.delete(entity, true);
    }

    @Override
    public void delete(ExecutionEntity entity, boolean fireDeleteEvent) {
        super.delete(entity, fireDeleteEvent);
        entity.setDeleted(true);
    }

    @Override
    public ExecutionEntity findSubProcessInstanceBySuperExecutionId(String superExecutionId) {
        return this.executionDataManager.findSubProcessInstanceBySuperExecutionId(superExecutionId);
    }

    @Override
    public List<ExecutionEntity> findChildExecutionsByParentExecutionId(String parentExecutionId) {
        return this.executionDataManager.findChildExecutionsByParentExecutionId(parentExecutionId);
    }

    @Override
    public List<ExecutionEntity> findChildExecutionsByProcessInstanceId(String processInstanceId) {
        return this.executionDataManager.findChildExecutionsByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<ExecutionEntity> findExecutionsByParentExecutionAndActivityIds(String parentExecutionId, Collection<String> activityIds) {
        return this.executionDataManager.findExecutionsByParentExecutionAndActivityIds(parentExecutionId, activityIds);
    }

    @Override
    public long findExecutionCountByQueryCriteria(ExecutionQueryImpl executionQuery) {
        return this.executionDataManager.findExecutionCountByQueryCriteria(executionQuery);
    }

    @Override
    public List<ExecutionEntity> findExecutionsByQueryCriteria(ExecutionQueryImpl executionQuery, Page page) {
        return this.executionDataManager.findExecutionsByQueryCriteria(executionQuery, page);
    }

    @Override
    public long findProcessInstanceCountByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        return this.executionDataManager.findProcessInstanceCountByQueryCriteria(executionQuery);
    }

    @Override
    public List<ProcessInstance> findProcessInstanceByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        return this.executionDataManager.findProcessInstanceByQueryCriteria(executionQuery);
    }

    @Override
    public ExecutionEntity findByRootProcessInstanceId(String rootProcessInstanceId) {
        List<ExecutionEntity> executions = this.executionDataManager.findExecutionsByRootProcessInstanceId(rootProcessInstanceId);
        return this.processExecutionTree(rootProcessInstanceId, executions);
    }

    protected ExecutionEntity processExecutionTree(String rootProcessInstanceId, List<ExecutionEntity> executions) {
        ExecutionEntity rootExecution = null;
        HashMap<String, ExecutionEntity> executionMap = new HashMap<String, ExecutionEntity>(executions.size());
        for (ExecutionEntity executionEntity : executions) {
            if (executionEntity.getId().equals(rootProcessInstanceId)) {
                rootExecution = executionEntity;
            }
            executionMap.put(executionEntity.getId(), executionEntity);
        }
        for (ExecutionEntity executionEntity : executions) {
            if (executionEntity.getRootProcessInstanceId() != null) {
                executionEntity.setRootProcessInstance((ExecutionEntity)executionMap.get(executionEntity.getRootProcessInstanceId()));
            }
            if (executionEntity.getProcessInstanceId() != null) {
                executionEntity.setProcessInstance((ExecutionEntity)executionMap.get(executionEntity.getProcessInstanceId()));
            }
            if (executionEntity.getParentId() != null) {
                ExecutionEntity parentExecutionEntity = (ExecutionEntity)executionMap.get(executionEntity.getParentId());
                executionEntity.setParent(parentExecutionEntity);
                parentExecutionEntity.addChildExecution(executionEntity);
            }
            if (executionEntity.getSuperExecution() == null) continue;
            ExecutionEntity superExecutionEntity = (ExecutionEntity)executionMap.get(executionEntity.getSuperExecutionId());
            executionEntity.setSuperExecution(superExecutionEntity);
            superExecutionEntity.setSubProcessInstance(executionEntity);
        }
        return rootExecution;
    }

    @Override
    public List<ProcessInstance> findProcessInstanceAndVariablesByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        return this.executionDataManager.findProcessInstanceAndVariablesByQueryCriteria(executionQuery);
    }

    @Override
    public Collection<ExecutionEntity> findInactiveExecutionsByProcessInstanceId(String processInstanceId) {
        return this.executionDataManager.findInactiveExecutionsByProcessInstanceId(processInstanceId);
    }

    @Override
    public Collection<ExecutionEntity> findInactiveExecutionsByActivityIdAndProcessInstanceId(String activityId, String processInstanceId) {
        return this.executionDataManager.findInactiveExecutionsByActivityIdAndProcessInstanceId(activityId, processInstanceId);
    }

    @Override
    public List<Execution> findExecutionsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.executionDataManager.findExecutionsByNativeQuery(parameterMap, firstResult, maxResults);
    }

    @Override
    public List<ProcessInstance> findProcessInstanceByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.executionDataManager.findProcessInstanceByNativeQuery(parameterMap, firstResult, maxResults);
    }

    @Override
    public long findExecutionCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.executionDataManager.findExecutionCountByNativeQuery(parameterMap);
    }

    @Override
    public ExecutionEntity createProcessInstanceExecution(ProcessDefinition processDefinition, String businessKey, String tenantId, String initiatorVariableName) {
        ExecutionEntity processInstanceExecution = (ExecutionEntity)this.executionDataManager.create();
        if (this.isExecutionRelatedEntityCountEnabledGlobally()) {
            ((CountingExecutionEntity)((Object)processInstanceExecution)).setCountEnabled(true);
        }
        processInstanceExecution.setProcessDefinitionId(processDefinition.getId());
        processInstanceExecution.setProcessDefinitionKey(processDefinition.getKey());
        processInstanceExecution.setProcessDefinitionName(processDefinition.getName());
        processInstanceExecution.setProcessDefinitionVersion(processDefinition.getVersion());
        processInstanceExecution.setBusinessKey(businessKey);
        processInstanceExecution.setScope(true);
        if (tenantId != null) {
            processInstanceExecution.setTenantId(tenantId);
        }
        String authenticatedUserId = Authentication.getAuthenticatedUserId();
        processInstanceExecution.setStartTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        processInstanceExecution.setStartUserId(authenticatedUserId);
        this.insert(processInstanceExecution, false);
        if (initiatorVariableName != null) {
            processInstanceExecution.setVariable(initiatorVariableName, authenticatedUserId);
        }
        processInstanceExecution.setProcessInstanceId(processInstanceExecution.getId());
        processInstanceExecution.setRootProcessInstanceId(processInstanceExecution.getId());
        if (authenticatedUserId != null) {
            this.getIdentityLinkEntityManager().addIdentityLink(processInstanceExecution, authenticatedUserId, null, "starter");
        }
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, processInstanceExecution));
        }
        return processInstanceExecution;
    }

    @Override
    public ExecutionEntity createChildExecution(ExecutionEntity parentExecutionEntity) {
        ExecutionEntity childExecution = (ExecutionEntity)this.executionDataManager.create();
        this.inheritCommonProperties(parentExecutionEntity, childExecution);
        childExecution.setParent(parentExecutionEntity);
        childExecution.setProcessDefinitionId(parentExecutionEntity.getProcessDefinitionId());
        childExecution.setProcessDefinitionKey(parentExecutionEntity.getProcessDefinitionKey());
        childExecution.setProcessInstanceId(parentExecutionEntity.getProcessInstanceId() != null ? parentExecutionEntity.getProcessInstanceId() : parentExecutionEntity.getId());
        childExecution.setScope(false);
        parentExecutionEntity.addChildExecution(childExecution);
        this.insert(childExecution, false);
        if (logger.isDebugEnabled()) {
            logger.debug("Child execution {} created with parent {}", (Object)childExecution, (Object)parentExecutionEntity.getId());
        }
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, childExecution));
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, childExecution));
        }
        return childExecution;
    }

    @Override
    public ExecutionEntity createSubprocessInstance(ProcessDefinition processDefinition, ExecutionEntity superExecutionEntity, String businessKey) {
        ExecutionEntity subProcessInstance = (ExecutionEntity)this.executionDataManager.create();
        this.inheritCommonProperties(superExecutionEntity, subProcessInstance);
        subProcessInstance.setProcessDefinitionId(processDefinition.getId());
        subProcessInstance.setProcessDefinitionKey(processDefinition.getKey());
        subProcessInstance.setSuperExecution(superExecutionEntity);
        subProcessInstance.setRootProcessInstanceId(superExecutionEntity.getRootProcessInstanceId());
        subProcessInstance.setScope(true);
        subProcessInstance.setStartUserId(Authentication.getAuthenticatedUserId());
        subProcessInstance.setBusinessKey(businessKey);
        this.insert(subProcessInstance, false);
        if (logger.isDebugEnabled()) {
            logger.debug("Child execution {} created with super execution {}", (Object)subProcessInstance, (Object)superExecutionEntity.getId());
        }
        subProcessInstance.setProcessInstanceId(subProcessInstance.getId());
        superExecutionEntity.setSubProcessInstance(subProcessInstance);
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, subProcessInstance));
        }
        return subProcessInstance;
    }

    protected void inheritCommonProperties(ExecutionEntity parentExecutionEntity, ExecutionEntity childExecution) {
        if (parentExecutionEntity instanceof CountingExecutionEntity) {
            CountingExecutionEntity countingParentExecutionEntity = (CountingExecutionEntity)((Object)parentExecutionEntity);
            ((CountingExecutionEntity)((Object)childExecution)).setCountEnabled(countingParentExecutionEntity.isCountEnabled());
        }
        childExecution.setRootProcessInstanceId(parentExecutionEntity.getRootProcessInstanceId());
        childExecution.setActive(true);
        childExecution.setStartTime(this.processEngineConfiguration.getClock().getCurrentTime());
        if (parentExecutionEntity.getTenantId() != null) {
            childExecution.setTenantId(parentExecutionEntity.getTenantId());
        }
    }

    @Override
    public void updateExecutionTenantIdForDeployment(String deploymentId, String newTenantId) {
        this.executionDataManager.updateExecutionTenantIdForDeployment(deploymentId, newTenantId);
    }

    @Override
    public void deleteProcessInstancesByProcessDefinition(String processDefinitionId, String deleteReason, boolean cascade) {
        List<String> processInstanceIds = this.executionDataManager.findProcessInstanceIdsByProcessDefinitionId(processDefinitionId);
        for (String processInstanceId : processInstanceIds) {
            this.deleteProcessInstance(processInstanceId, deleteReason, cascade);
        }
        if (cascade) {
            this.getHistoricProcessInstanceEntityManager().deleteHistoricProcessInstanceByProcessDefinitionId(processDefinitionId);
        }
    }

    @Override
    public void deleteProcessInstance(String processInstanceId, String deleteReason, boolean cascade) {
        ExecutionEntity execution = (ExecutionEntity)this.findById(processInstanceId);
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("No process instance found for id '" + processInstanceId + "'", ProcessInstance.class);
        }
        this.deleteProcessInstanceCascade(execution, deleteReason, cascade);
    }

    protected void deleteProcessInstanceCascade(ExecutionEntity execution, String deleteReason, boolean deleteHistory) {
        ExecutionEntity processInstanceExecutionEntity;
        if (deleteReason == null) {
            deleteReason = "process instance deleted";
        }
        for (ExecutionEntity executionEntity : execution.getExecutions()) {
            if (executionEntity.isMultiInstanceRoot()) {
                for (ExecutionEntity executionEntity2 : executionEntity.getExecutions()) {
                    if (executionEntity2.getSubProcessInstance() == null) continue;
                    this.deleteProcessInstanceCascade(executionEntity2.getSubProcessInstance(), deleteReason, deleteHistory);
                }
                continue;
            }
            if (executionEntity.getSubProcessInstance() == null) continue;
            this.deleteProcessInstanceCascade(executionEntity.getSubProcessInstance(), deleteReason, deleteHistory);
        }
        this.getTaskEntityManager().deleteTasksByProcessInstanceId(execution.getId(), deleteReason, deleteHistory);
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createCancelledEvent(execution.getProcessInstanceId(), execution.getProcessInstanceId(), null, deleteReason));
        }
        if ((processInstanceExecutionEntity = execution.getProcessInstance()) == null) {
            return;
        }
        List<ExecutionEntity> list = this.collectChildren(execution.getProcessInstance());
        for (int i = list.size() - 1; i >= 0; --i) {
            ExecutionEntity executionEntity = list.get(i);
            this.deleteExecutionAndRelatedData(executionEntity, deleteReason, false);
        }
        this.deleteExecutionAndRelatedData(execution, deleteReason, false);
        if (deleteHistory) {
            this.getHistoricProcessInstanceEntityManager().delete(execution.getId());
        }
        this.getHistoryManager().recordProcessInstanceEnd(processInstanceExecutionEntity.getId(), deleteReason, null);
        processInstanceExecutionEntity.setDeleted(true);
    }

    @Override
    public void deleteExecutionAndRelatedData(ExecutionEntity executionEntity, String deleteReason, boolean cancel) {
        this.getHistoryManager().recordActivityEnd(executionEntity, deleteReason);
        this.deleteDataForExecution(executionEntity, deleteReason, cancel);
        this.delete(executionEntity);
    }

    @Override
    public void deleteProcessInstanceExecutionEntity(String processInstanceId, String currentFlowElementId, String deleteReason, boolean cascade, boolean cancel) {
        ExecutionEntity processInstanceEntity = (ExecutionEntity)this.findById(processInstanceId);
        if (processInstanceEntity == null) {
            throw new ActivitiObjectNotFoundException("No process instance found for id '" + processInstanceId + "'", ProcessInstance.class);
        }
        if (processInstanceEntity.isDeleted()) {
            return;
        }
        for (ExecutionEntity executionEntity : processInstanceEntity.getExecutions()) {
            if (executionEntity.getSubProcessInstance() == null || executionEntity.isEnded()) continue;
            this.deleteProcessInstanceCascade(executionEntity.getSubProcessInstance(), deleteReason, cascade);
        }
        for (ExecutionEntity executionEntity : processInstanceEntity.getExecutions()) {
            if (!executionEntity.isEventScope()) continue;
            this.deleteExecutionAndRelatedData(executionEntity, null, false);
        }
        this.deleteChildExecutions(processInstanceEntity, deleteReason, cancel);
        this.deleteExecutionAndRelatedData(processInstanceEntity, deleteReason, cancel);
        if (this.getEventDispatcher().isEnabled()) {
            if (!cancel) {
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.PROCESS_COMPLETED, processInstanceEntity));
            } else {
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createCancelledEvent(processInstanceEntity.getId(), processInstanceEntity.getId(), processInstanceEntity.getProcessDefinitionId(), deleteReason));
            }
        }
        this.getHistoryManager().recordProcessInstanceEnd(processInstanceEntity.getId(), deleteReason, currentFlowElementId);
        processInstanceEntity.setDeleted(true);
    }

    @Override
    public void deleteChildExecutions(ExecutionEntity executionEntity, String deleteReason, boolean cancel) {
        List<ExecutionEntity> childExecutions = this.collectChildren(executionEntity);
        for (int i = childExecutions.size() - 1; i >= 0; --i) {
            ExecutionEntity childExecutionEntity = childExecutions.get(i);
            if (childExecutionEntity.isEnded()) continue;
            this.deleteExecutionAndRelatedData(childExecutionEntity, deleteReason, cancel);
        }
    }

    @Override
    public List<ExecutionEntity> collectChildren(ExecutionEntity executionEntity) {
        ArrayList<ExecutionEntity> childExecutions = new ArrayList<ExecutionEntity>();
        this.collectChildren(executionEntity, childExecutions);
        return childExecutions;
    }

    protected void collectChildren(ExecutionEntity executionEntity, List<ExecutionEntity> collectedChildExecution) {
        ExecutionEntity subProcessInstance;
        List<? extends ExecutionEntity> childExecutions = executionEntity.getExecutions();
        if (childExecutions != null && childExecutions.size() > 0) {
            for (ExecutionEntity executionEntity2 : childExecutions) {
                if (executionEntity2.isDeleted()) continue;
                collectedChildExecution.add(executionEntity2);
                this.collectChildren(executionEntity2, collectedChildExecution);
            }
        }
        if ((subProcessInstance = executionEntity.getSubProcessInstance()) != null && !subProcessInstance.isDeleted()) {
            collectedChildExecution.add(subProcessInstance);
            this.collectChildren(subProcessInstance, collectedChildExecution);
        }
    }

    @Override
    public ExecutionEntity findFirstScope(ExecutionEntity executionEntity) {
        ExecutionEntity currentExecutionEntity = executionEntity;
        while (currentExecutionEntity != null) {
            if (currentExecutionEntity.isScope()) {
                return currentExecutionEntity;
            }
            ExecutionEntity parentExecutionEntity = currentExecutionEntity.getParent();
            if (parentExecutionEntity == null) {
                parentExecutionEntity = currentExecutionEntity.getSuperExecution();
            }
            currentExecutionEntity = parentExecutionEntity;
        }
        return null;
    }

    @Override
    public ExecutionEntity findFirstMultiInstanceRoot(ExecutionEntity executionEntity) {
        ExecutionEntity currentExecutionEntity = executionEntity;
        while (currentExecutionEntity != null) {
            if (currentExecutionEntity.isMultiInstanceRoot()) {
                return currentExecutionEntity;
            }
            ExecutionEntity parentExecutionEntity = currentExecutionEntity.getParent();
            if (parentExecutionEntity == null) {
                parentExecutionEntity = currentExecutionEntity.getSuperExecution();
            }
            currentExecutionEntity = parentExecutionEntity;
        }
        return null;
    }

    public void deleteDataForExecution(ExecutionEntity executionEntity, String deleteReason, boolean cancel) {
        executionEntity.setEnded(true);
        executionEntity.setActive(false);
        boolean enableExecutionRelationshipCounts = this.isExecutionRelatedEntityCountEnabled(executionEntity);
        if (executionEntity.getId().equals(executionEntity.getProcessInstanceId()) && (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getIdentityLinkCount() > 0)) {
            IdentityLinkEntityManager identityLinkEntityManager = this.getIdentityLinkEntityManager();
            List<IdentityLinkEntity> identityLinks = identityLinkEntityManager.findIdentityLinksByProcessInstanceId(executionEntity.getProcessInstanceId());
            for (IdentityLinkEntity identityLinkEntity : identityLinks) {
                identityLinkEntityManager.delete(identityLinkEntity);
            }
        }
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getVariableCount() > 0) {
            Collection<VariableInstance> executionVariables = executionEntity.getVariableInstancesLocal().values();
            for (VariableInstance variableInstance : executionVariables) {
                VariableInstanceEntity variableInstanceEntity = (VariableInstanceEntity)variableInstance;
                VariableInstanceEntityManager variableInstanceEntityManager = this.getVariableInstanceEntityManager();
                variableInstanceEntityManager.delete(variableInstanceEntity);
                if (variableInstanceEntity.getByteArrayRef() == null || variableInstanceEntity.getByteArrayRef().getId() == null) continue;
                this.getByteArrayEntityManager().deleteByteArrayById(variableInstanceEntity.getByteArrayRef().getId());
            }
        }
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getTaskCount() > 0) {
            TaskEntityManager taskEntityManager = this.getTaskEntityManager();
            List<TaskEntity> tasksForExecution = taskEntityManager.findTasksByExecutionId(executionEntity.getId());
            for (TaskEntity taskEntity : tasksForExecution) {
                taskEntityManager.deleteTask(taskEntity, deleteReason, false, cancel);
            }
        }
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getTimerJobCount() > 0) {
            TimerJobEntityManager timerJobEntityManager = this.getTimerJobEntityManager();
            List<TimerJobEntity> timerJobsForExecution = timerJobEntityManager.findJobsByExecutionId(executionEntity.getId());
            for (TimerJobEntity timerJobEntity : timerJobsForExecution) {
                timerJobEntityManager.delete(timerJobEntity);
                if (!this.getEventDispatcher().isEnabled()) continue;
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, timerJobEntity));
            }
        }
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getJobCount() > 0) {
            JobEntityManager jobEntityManager = this.getJobEntityManager();
            List<JobEntity> jobsForExecution = jobEntityManager.findJobsByExecutionId(executionEntity.getId());
            for (JobEntity jobEntity : jobsForExecution) {
                this.getJobEntityManager().delete(jobEntity);
                if (!this.getEventDispatcher().isEnabled()) continue;
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, jobEntity));
            }
        }
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getSuspendedJobCount() > 0) {
            SuspendedJobEntityManager suspendedJobEntityManager = this.getSuspendedJobEntityManager();
            List<SuspendedJobEntity> suspendedJobsForExecution = suspendedJobEntityManager.findJobsByExecutionId(executionEntity.getId());
            for (SuspendedJobEntity suspendedJobEntity : suspendedJobsForExecution) {
                suspendedJobEntityManager.delete(suspendedJobEntity);
                if (!this.getEventDispatcher().isEnabled()) continue;
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, suspendedJobEntity));
            }
        }
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getDeadLetterJobCount() > 0) {
            DeadLetterJobEntityManager deadLetterJobEntityManager = this.getDeadLetterJobEntityManager();
            List<DeadLetterJobEntity> deadLetterJobsForExecution = deadLetterJobEntityManager.findJobsByExecutionId(executionEntity.getId());
            for (DeadLetterJobEntity deadLetterJobEntity : deadLetterJobsForExecution) {
                deadLetterJobEntityManager.delete(deadLetterJobEntity);
                if (!this.getEventDispatcher().isEnabled()) continue;
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, deadLetterJobEntity));
            }
        }
        if (!enableExecutionRelationshipCounts || enableExecutionRelationshipCounts && ((CountingExecutionEntity)((Object)executionEntity)).getEventSubscriptionCount() > 0) {
            EventSubscriptionEntityManager eventSubscriptionEntityManager = this.getEventSubscriptionEntityManager();
            List<EventSubscriptionEntity> eventSubscriptions = eventSubscriptionEntityManager.findEventSubscriptionsByExecution(executionEntity.getId());
            for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
                eventSubscriptionEntityManager.delete(eventSubscriptionEntity);
            }
        }
    }

    @Override
    public void updateProcessInstanceLockTime(String processInstanceId) {
        Date expirationTime = this.getClock().getCurrentTime();
        int lockMillis = this.getAsyncExecutor().getAsyncJobLockTimeInMillis();
        GregorianCalendar lockCal = new GregorianCalendar();
        lockCal.setTime(expirationTime);
        lockCal.add(14, lockMillis);
        Date lockDate = lockCal.getTime();
        this.executionDataManager.updateProcessInstanceLockTime(processInstanceId, lockDate, expirationTime);
    }

    @Override
    public void clearProcessInstanceLockTime(String processInstanceId) {
        this.executionDataManager.clearProcessInstanceLockTime(processInstanceId);
    }

    @Override
    public String updateProcessInstanceBusinessKey(ExecutionEntity executionEntity, String businessKey) {
        if (executionEntity.isProcessInstanceType() && businessKey != null) {
            executionEntity.setBusinessKey(businessKey);
            this.getHistoryManager().updateProcessBusinessKeyInHistory(executionEntity);
            if (this.getEventDispatcher().isEnabled()) {
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, executionEntity));
            }
            return businessKey;
        }
        return null;
    }

    public ExecutionDataManager getExecutionDataManager() {
        return this.executionDataManager;
    }

    public void setExecutionDataManager(ExecutionDataManager executionDataManager) {
        this.executionDataManager = executionDataManager;
    }
}

