/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.engine.impl.GroupQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.GroupEntity;
import org.activiti.engine.impl.persistence.entity.GroupEntityManager;
import org.activiti.engine.impl.persistence.entity.data.DataManager;
import org.activiti.engine.impl.persistence.entity.data.GroupDataManager;

public class GroupEntityManagerImpl
extends AbstractEntityManager<GroupEntity>
implements GroupEntityManager {
    protected GroupDataManager groupDataManager;

    public GroupEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, GroupDataManager groupDataManager) {
        super(processEngineConfiguration);
        this.groupDataManager = groupDataManager;
    }

    @Override
    protected DataManager<GroupEntity> getDataManager() {
        return this.groupDataManager;
    }

    @Override
    public Group createNewGroup(String groupId) {
        GroupEntity groupEntity = (GroupEntity)this.groupDataManager.create();
        groupEntity.setId(groupId);
        groupEntity.setRevision(0);
        return groupEntity;
    }

    @Override
    public void delete(String groupId) {
        GroupEntity group = (GroupEntity)this.groupDataManager.findById(groupId);
        if (group != null) {
            this.getMembershipEntityManager().deleteMembershipByGroupId(groupId);
            if (this.getEventDispatcher().isEnabled()) {
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createMembershipEvent(ActivitiEventType.MEMBERSHIPS_DELETED, groupId, null));
            }
            this.delete(group);
        }
    }

    @Override
    public GroupQuery createNewGroupQuery() {
        return new GroupQueryImpl(this.getCommandExecutor());
    }

    @Override
    public List<Group> findGroupByQueryCriteria(GroupQueryImpl query, Page page) {
        return this.groupDataManager.findGroupByQueryCriteria(query, page);
    }

    @Override
    public long findGroupCountByQueryCriteria(GroupQueryImpl query) {
        return this.groupDataManager.findGroupCountByQueryCriteria(query);
    }

    @Override
    public List<Group> findGroupsByUser(String userId) {
        return this.groupDataManager.findGroupsByUser(userId);
    }

    @Override
    public List<Group> findGroupsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.groupDataManager.findGroupsByNativeQuery(parameterMap, firstResult, maxResults);
    }

    @Override
    public long findGroupCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.groupDataManager.findGroupCountByNativeQuery(parameterMap);
    }

    @Override
    public boolean isNewGroup(Group group) {
        return ((GroupEntity)group).getRevision() == 0;
    }

    public GroupDataManager getGroupDataManager() {
        return this.groupDataManager;
    }

    public void setGroupDataManager(GroupDataManager groupDataManager) {
        this.groupDataManager = groupDataManager;
    }
}

