/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.deployer;

import java.util.LinkedHashMap;
import java.util.Map;
import org.activiti.form.engine.impl.cfg.IdGenerator;
import org.activiti.form.engine.impl.context.Context;
import org.activiti.form.engine.impl.deployer.CachingAndArtifactsManager;
import org.activiti.form.engine.impl.deployer.FormDeploymentHelper;
import org.activiti.form.engine.impl.deployer.ParsedDeployment;
import org.activiti.form.engine.impl.deployer.ParsedDeploymentBuilderFactory;
import org.activiti.form.engine.impl.interceptor.CommandContext;
import org.activiti.form.engine.impl.persistence.deploy.Deployer;
import org.activiti.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.activiti.form.engine.impl.persistence.entity.FormEntity;
import org.activiti.form.engine.impl.persistence.entity.FormEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormDeployer
implements Deployer {
    private static final Logger log = LoggerFactory.getLogger(FormDeployer.class);
    protected IdGenerator idGenerator;
    protected ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory;
    protected FormDeploymentHelper formDeploymentHelper;
    protected CachingAndArtifactsManager cachingAndArtifactsManager;

    @Override
    public void deploy(FormDeploymentEntity deployment) {
        log.debug("Processing deployment {}", (Object)deployment.getName());
        ParsedDeployment parsedDeployment = this.parsedDeploymentBuilderFactory.getBuilderForDeployment(deployment).build();
        this.formDeploymentHelper.verifyFormsDoNotShareKeys(parsedDeployment.getAllForms());
        this.formDeploymentHelper.copyDeploymentValuesToForms(parsedDeployment.getDeployment(), parsedDeployment.getAllForms());
        this.formDeploymentHelper.setResourceNamesOnForms(parsedDeployment);
        if (deployment.isNew()) {
            Map<FormEntity, FormEntity> mapOfNewFormToPreviousVersion = this.getPreviousVersionsOfForms(parsedDeployment);
            this.setFormVersionsAndIds(parsedDeployment, mapOfNewFormToPreviousVersion);
            this.persistForms(parsedDeployment);
        } else {
            this.makeFormsConsistentWithPersistedVersions(parsedDeployment);
        }
        this.cachingAndArtifactsManager.updateCachingAndArtifacts(parsedDeployment);
    }

    protected Map<FormEntity, FormEntity> getPreviousVersionsOfForms(ParsedDeployment parsedDeployment) {
        LinkedHashMap<FormEntity, FormEntity> result = new LinkedHashMap<FormEntity, FormEntity>();
        for (FormEntity newDefinition : parsedDeployment.getAllForms()) {
            FormEntity existingForm = this.formDeploymentHelper.getMostRecentVersionOfForm(newDefinition);
            if (existingForm == null) continue;
            result.put(newDefinition, existingForm);
        }
        return result;
    }

    protected void setFormVersionsAndIds(ParsedDeployment parsedDeployment, Map<FormEntity, FormEntity> mapNewToOldForms) {
        for (FormEntity form : parsedDeployment.getAllForms()) {
            int version = 1;
            FormEntity latest = mapNewToOldForms.get(form);
            if (latest != null) {
                version = latest.getVersion() + 1;
            }
            form.setVersion(version);
            form.setId(this.idGenerator.getNextId());
        }
    }

    protected void persistForms(ParsedDeployment parsedDeployment) {
        CommandContext commandContext = Context.getCommandContext();
        FormEntityManager formEntityManager = commandContext.getFormEntityManager();
        for (FormEntity form : parsedDeployment.getAllForms()) {
            formEntityManager.insert(form);
        }
    }

    protected void makeFormsConsistentWithPersistedVersions(ParsedDeployment parsedDeployment) {
        for (FormEntity form : parsedDeployment.getAllForms()) {
            FormEntity persistedForm = this.formDeploymentHelper.getPersistedInstanceOfForm(form);
            if (persistedForm == null) continue;
            form.setId(persistedForm.getId());
            form.setVersion(persistedForm.getVersion());
        }
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public ParsedDeploymentBuilderFactory getExParsedDeploymentBuilderFactory() {
        return this.parsedDeploymentBuilderFactory;
    }

    public void setParsedDeploymentBuilderFactory(ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory) {
        this.parsedDeploymentBuilderFactory = parsedDeploymentBuilderFactory;
    }

    public FormDeploymentHelper getFormDeploymentHelper() {
        return this.formDeploymentHelper;
    }

    public void setFormDeploymentHelper(FormDeploymentHelper formDeploymentHelper) {
        this.formDeploymentHelper = formDeploymentHelper;
    }

    public CachingAndArtifactsManager getCachingAndArtifcatsManager() {
        return this.cachingAndArtifactsManager;
    }

    public void setCachingAndArtifactsManager(CachingAndArtifactsManager manager) {
        this.cachingAndArtifactsManager = manager;
    }
}

