/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.editor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.activiti.app.domain.editor.AbstractModel;
import org.activiti.app.domain.editor.AppDefinition;
import org.activiti.app.domain.editor.Model;
import org.activiti.app.model.common.ResultListDataRepresentation;
import org.activiti.app.model.editor.ModelKeyRepresentation;
import org.activiti.app.model.editor.ModelRepresentation;
import org.activiti.app.model.editor.decisiontable.DecisionTableDefinitionRepresentation;
import org.activiti.app.rest.editor.AbstractModelsResource;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.exception.InternalServerErrorException;
import org.activiti.form.model.FormDefinition;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class ModelsResource
extends AbstractModelsResource {
    private final Logger logger = LoggerFactory.getLogger(ModelsResource.class);

    @Override
    @RequestMapping(value={"/rest/models"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultListDataRepresentation getModels(@RequestParam(required=false) String filter, @RequestParam(required=false) String sort, @RequestParam(required=false) Integer modelType, HttpServletRequest request) {
        return super.getModels(filter, sort, modelType, request);
    }

    @Override
    @RequestMapping(value={"/rest/models-for-app-definition"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultListDataRepresentation getModelsToIncludeInAppDefinition() {
        return super.getModelsToIncludeInAppDefinition();
    }

    @Override
    @RequestMapping(value={"/rest/import-process-model"}, method={RequestMethod.POST}, produces={"application/json"})
    public ModelRepresentation importProcessModel(HttpServletRequest request, @RequestParam(value="file") MultipartFile file) {
        return super.importProcessModel(request, file);
    }

    @RequestMapping(value={"/rest/import-process-model/text"}, method={RequestMethod.POST})
    public String importProcessModelText(HttpServletRequest request, @RequestParam(value="file") MultipartFile file) {
        ModelRepresentation modelRepresentation = super.importProcessModel(request, file);
        String modelRepresentationJson = null;
        try {
            modelRepresentationJson = this.objectMapper.writeValueAsString((Object)modelRepresentation);
        }
        catch (Exception e) {
            this.logger.error("Error while processing Model representation json", (Throwable)e);
            throw new InternalServerErrorException("Model Representation could not be saved");
        }
        return modelRepresentationJson;
    }

    @RequestMapping(value={"/rest/models"}, method={RequestMethod.POST}, produces={"application/json"})
    public ModelRepresentation createModel(@RequestBody ModelRepresentation modelRepresentation) {
        modelRepresentation.setKey(modelRepresentation.getKey().replaceAll(" ", ""));
        ModelKeyRepresentation modelKeyInfo = this.modelService.validateModelKey(null, modelRepresentation.getModelType(), modelRepresentation.getKey());
        if (modelKeyInfo.isKeyAlreadyExists()) {
            throw new BadRequestException("Provided model key already exists: " + modelRepresentation.getKey());
        }
        String json = null;
        if (modelRepresentation.getModelType() != null && modelRepresentation.getModelType().equals(2)) {
            try {
                json = this.objectMapper.writeValueAsString((Object)new FormDefinition());
            }
            catch (Exception e) {
                this.logger.error("Error creating form model", (Throwable)e);
                throw new InternalServerErrorException("Error creating form");
            }
        } else if (modelRepresentation.getModelType() != null && modelRepresentation.getModelType().equals(4)) {
            try {
                DecisionTableDefinitionRepresentation decisionTableDefinition = new DecisionTableDefinitionRepresentation();
                String decisionTableDefinitionKey = modelRepresentation.getName().replaceAll(" ", "");
                decisionTableDefinition.setKey(decisionTableDefinitionKey);
                json = this.objectMapper.writeValueAsString((Object)decisionTableDefinition);
            }
            catch (Exception e) {
                this.logger.error("Error creating decision table model", (Throwable)e);
                throw new InternalServerErrorException("Error creating decision table");
            }
        } else if (modelRepresentation.getModelType() != null && modelRepresentation.getModelType().equals(3)) {
            try {
                json = this.objectMapper.writeValueAsString((Object)new AppDefinition());
            }
            catch (Exception e) {
                this.logger.error("Error creating app definition", (Throwable)e);
                throw new InternalServerErrorException("Error creating app definition");
            }
        } else {
            ObjectNode editorNode = this.objectMapper.createObjectNode();
            editorNode.put("id", "canvas");
            editorNode.put("resourceId", "canvas");
            ObjectNode stencilSetNode = this.objectMapper.createObjectNode();
            stencilSetNode.put("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
            editorNode.put("stencilset", (JsonNode)stencilSetNode);
            ObjectNode propertiesNode = this.objectMapper.createObjectNode();
            propertiesNode.put("process_id", modelRepresentation.getKey());
            propertiesNode.put("name", modelRepresentation.getName());
            if (StringUtils.isNotEmpty((CharSequence)modelRepresentation.getDescription())) {
                propertiesNode.put("documentation", modelRepresentation.getDescription());
            }
            editorNode.put("properties", (JsonNode)propertiesNode);
            ArrayNode childShapeArray = this.objectMapper.createArrayNode();
            editorNode.put("childShapes", (JsonNode)childShapeArray);
            ObjectNode childNode = this.objectMapper.createObjectNode();
            childShapeArray.add((JsonNode)childNode);
            ObjectNode boundsNode = this.objectMapper.createObjectNode();
            childNode.put("bounds", (JsonNode)boundsNode);
            ObjectNode lowerRightNode = this.objectMapper.createObjectNode();
            boundsNode.put("lowerRight", (JsonNode)lowerRightNode);
            lowerRightNode.put("x", 130);
            lowerRightNode.put("y", 193);
            ObjectNode upperLeftNode = this.objectMapper.createObjectNode();
            boundsNode.put("upperLeft", (JsonNode)upperLeftNode);
            upperLeftNode.put("x", 100);
            upperLeftNode.put("y", 163);
            childNode.put("childShapes", (JsonNode)this.objectMapper.createArrayNode());
            childNode.put("dockers", (JsonNode)this.objectMapper.createArrayNode());
            childNode.put("outgoing", (JsonNode)this.objectMapper.createArrayNode());
            childNode.put("resourceId", "startEvent1");
            ObjectNode stencilNode = this.objectMapper.createObjectNode();
            childNode.put("stencil", (JsonNode)stencilNode);
            stencilNode.put("id", "StartNoneEvent");
            json = editorNode.toString();
        }
        Model newModel = this.modelService.createModel(modelRepresentation, json, SecurityUtils.getCurrentUserObject());
        return new ModelRepresentation((AbstractModel)newModel);
    }

    @RequestMapping(value={"/rest/models/{modelId}/clone"}, method={RequestMethod.POST}, produces={"application/json"})
    public ModelRepresentation duplicateModel(@PathVariable String modelId, @RequestBody ModelRepresentation modelRepresentation) {
        String json = null;
        Model model = null;
        if (modelId != null) {
            model = this.modelService.getModel(modelId);
            json = model.getModelEditorJson();
        }
        if (model == null) {
            throw new InternalServerErrorException("Error duplicating model : Unknown original model");
        }
        if (!(modelRepresentation.getModelType() != null && modelRepresentation.getModelType().equals(2) || modelRepresentation.getModelType() != null && modelRepresentation.getModelType().equals(3))) {
            ObjectNode editorNode;
            if (modelRepresentation.getModelType() != null && modelRepresentation.getModelType().equals(4)) {
                editorNode = null;
                try {
                    editorNode = (ObjectNode)this.objectMapper.readTree(json);
                    json = this.objectMapper.writeValueAsString((Object)editorNode);
                }
                catch (Exception e) {
                    this.logger.error("Error creating decision table model", (Throwable)e);
                    throw new InternalServerErrorException("Error creating decision table");
                }
            }
            editorNode = null;
            try {
                ObjectNode editorJsonNode = (ObjectNode)this.objectMapper.readTree(json);
                editorNode = this.deleteEmbededReferencesFromBPMNModel(editorJsonNode);
                ObjectNode propertiesNode = (ObjectNode)editorNode.get("properties");
                String processId = modelRepresentation.getName().replaceAll(" ", "");
                propertiesNode.put("process_id", processId);
                propertiesNode.put("name", modelRepresentation.getName());
                if (StringUtils.isNotEmpty((CharSequence)modelRepresentation.getDescription())) {
                    propertiesNode.put("documentation", modelRepresentation.getDescription());
                }
                editorNode.put("properties", (JsonNode)propertiesNode);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (editorNode != null) {
                json = editorNode.toString();
            }
        }
        Model newModel = this.modelService.createModel(modelRepresentation, json, SecurityUtils.getCurrentUserObject());
        byte[] imageBytes = model.getThumbnail();
        newModel = this.modelService.saveModel(newModel, newModel.getModelEditorJson(), imageBytes, false, newModel.getComment(), SecurityUtils.getCurrentUserObject());
        return new ModelRepresentation((AbstractModel)newModel);
    }

    protected ObjectNode deleteEmbededReferencesFromBPMNModel(ObjectNode editorJsonNode) {
        try {
            this.internalDeleteNodeByNameFromBPMNModel((JsonNode)editorJsonNode, "formreference");
            this.internalDeleteNodeByNameFromBPMNModel((JsonNode)editorJsonNode, "subprocessreference");
            return editorJsonNode;
        }
        catch (Exception e) {
            throw new InternalServerErrorException("Cannot delete the external references");
        }
    }

    protected ObjectNode deleteEmbededReferencesFromStepModel(ObjectNode editorJsonNode) {
        try {
            JsonNode startFormNode = editorJsonNode.get("startForm");
            if (startFormNode != null) {
                editorJsonNode.remove("startForm");
            }
            this.internalDeleteNodeByNameFromStepModel(editorJsonNode.get("steps"), "formDefinition");
            this.internalDeleteNodeByNameFromStepModel(editorJsonNode.get("steps"), "subProcessDefinition");
            return editorJsonNode;
        }
        catch (Exception e) {
            throw new InternalServerErrorException("Cannot delete the external references");
        }
    }

    protected void internalDeleteNodeByNameFromBPMNModel(JsonNode editorJsonNode, String propertyName) {
        JsonNode childShapesNode = editorJsonNode.get("childShapes");
        if (childShapesNode != null && childShapesNode.isArray()) {
            ArrayNode childShapesArrayNode = (ArrayNode)childShapesNode;
            for (JsonNode childShapeNode : childShapesArrayNode) {
                JsonNode propertyNode;
                ObjectNode properties = (ObjectNode)childShapeNode.get("properties");
                if (properties != null && properties.has(propertyName) && (propertyNode = properties.get(propertyName)) != null) {
                    properties.remove(propertyName);
                }
                if (!childShapeNode.has("childShapes")) continue;
                this.internalDeleteNodeByNameFromBPMNModel(childShapeNode, propertyName);
            }
        }
    }

    private void internalDeleteNodeByNameFromStepModel(JsonNode stepsNode, String propertyName) {
        if (stepsNode == null || !stepsNode.isArray()) {
            return;
        }
        for (JsonNode jsonNode : stepsNode) {
            JsonNode propertyNode;
            ObjectNode stepNode = (ObjectNode)jsonNode;
            if (stepNode.has(propertyName) && (propertyNode = stepNode.get(propertyName)) != null) {
                stepNode.remove(propertyName);
            }
            if (stepNode.has("steps")) {
                this.internalDeleteNodeByNameFromStepModel(stepNode.get("steps"), propertyName);
            }
            if (stepNode.has("overdueSteps")) {
                this.internalDeleteNodeByNameFromStepModel(stepNode.get("overdueSteps"), propertyName);
            }
            if (!stepNode.has("choices")) continue;
            ArrayNode choicesArrayNode = (ArrayNode)stepNode.get("choices");
            for (JsonNode choiceNode : choicesArrayNode) {
                if (!choiceNode.has("steps")) continue;
                this.internalDeleteNodeByNameFromStepModel(choiceNode.get("steps"), propertyName);
            }
        }
    }
}

