/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.exception.InternalServerErrorException;
import org.activiti.app.service.exception.NotFoundException;
import org.activiti.app.service.runtime.PermissionService;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.form.api.FormRepositoryService;
import org.activiti.form.model.FormDefinition;
import org.activiti.form.model.FormField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractProcessDefinitionResource {
    private final Logger logger = LoggerFactory.getLogger(AbstractProcessDefinitionResource.class);
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected FormRepositoryService formRepositoryService;
    @Autowired
    protected PermissionService permissionService;
    @Autowired
    protected ObjectMapper objectMapper;

    public FormDefinition getProcessDefinitionStartForm(HttpServletRequest request) {
        String[] requestInfoArray = this.parseRequest(request);
        String processDefinitionId = this.getProcessDefinitionId(requestInfoArray, requestInfoArray.length - 2);
        ProcessDefinition processDefinition = this.permissionService.getProcessDefinitionById(processDefinitionId);
        try {
            return this.getStartForm(processDefinition);
        }
        catch (ActivitiObjectNotFoundException aonfe) {
            throw new NotFoundException("No process definition found with the given id: " + processDefinitionId);
        }
    }

    protected FormDefinition getStartForm(ProcessDefinition processDefinition) {
        StartEvent startEvent;
        FormDefinition formDefinition = null;
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        Process process = bpmnModel.getProcessById(processDefinition.getKey());
        FlowElement startElement = process.getInitialFlowElement();
        if (startElement instanceof StartEvent && StringUtils.isNotEmpty((CharSequence)(startEvent = (StartEvent)startElement).getFormKey())) {
            formDefinition = this.formRepositoryService.getFormDefinitionByKeyAndParentDeploymentId(startEvent.getFormKey(), processDefinition.getDeploymentId(), processDefinition.getTenantId());
        }
        if (formDefinition == null) {
            throw new NotFoundException("Process definition does not have a form defined: " + processDefinition.getId());
        }
        return formDefinition;
    }

    protected ProcessDefinition getProcessDefinitionFromRequest(String[] requestInfoArray, boolean isTableRequest) {
        int paramPosition = requestInfoArray.length - 3;
        if (isTableRequest) {
            --paramPosition;
        }
        String processDefinitionId = this.getProcessDefinitionId(requestInfoArray, paramPosition);
        ProcessDefinition processDefinition = this.permissionService.getProcessDefinitionById(processDefinitionId);
        return processDefinition;
    }

    protected FormField getFormFieldFromRequest(String[] requestInfoArray, ProcessDefinition processDefinition, boolean isTableRequest) {
        FormDefinition form = this.getStartForm(processDefinition);
        int paramPosition = requestInfoArray.length - 1;
        if (isTableRequest) {
            --paramPosition;
        }
        String fieldVariable = requestInfoArray[paramPosition];
        List allFields = form.listAllFields();
        FormField selectedField = null;
        if (CollectionUtils.isNotEmpty((Collection)allFields)) {
            for (FormField formFieldRepresentation : allFields) {
                if (!formFieldRepresentation.getId().equalsIgnoreCase(fieldVariable)) continue;
                selectedField = formFieldRepresentation;
            }
        }
        if (selectedField == null) {
            throw new NotFoundException("Field could not be found in start form definition " + fieldVariable);
        }
        return selectedField;
    }

    protected String[] parseRequest(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String[] requestInfoArray = requestURI.split("/");
        if (requestInfoArray.length < 2) {
            throw new BadRequestException("Start form request is not valid " + requestURI);
        }
        return requestInfoArray;
    }

    protected String getProcessDefinitionId(String[] requestInfoArray, int position) {
        String processDefinitionVariable = requestInfoArray[position];
        String processDefinitionId = null;
        try {
            processDefinitionId = URLDecoder.decode(processDefinitionVariable, "UTF-8");
        }
        catch (Exception e) {
            this.logger.error("Error decoding process definition " + processDefinitionVariable, (Throwable)e);
            throw new InternalServerErrorException("Error decoding process definition " + processDefinitionVariable);
        }
        return processDefinitionId;
    }
}

