/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.rest.runtime;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.activiti.app.model.common.ResultListDataRepresentation;
import org.activiti.app.model.idm.UserRepresentation;
import org.activiti.app.model.runtime.TaskRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.api.UserCache;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.exception.NotPermittedException;
import org.activiti.app.service.runtime.PermissionService;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.identity.User;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HistoricTaskQueryResource {
    @Inject
    protected HistoryService historyService;
    @Inject
    protected UserCache userCache;
    @Inject
    protected PermissionService permissionService;

    @RequestMapping(value={"/rest/query/history/tasks"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultListDataRepresentation listTasks(@RequestBody ObjectNode requestNode) {
        JsonNode finishedNode;
        if (requestNode == null) {
            throw new BadRequestException("No request found");
        }
        HistoricTaskInstanceQuery taskQuery = this.historyService.createHistoricTaskInstanceQuery();
        User currentUser = SecurityUtils.getCurrentUserObject();
        JsonNode processInstanceIdNode = requestNode.get("processInstanceId");
        if (processInstanceIdNode != null && !processInstanceIdNode.isNull()) {
            String processInstanceId = processInstanceIdNode.asText();
            if (this.permissionService.hasReadPermissionOnProcessInstance(currentUser, processInstanceId)) {
                taskQuery.processInstanceId(processInstanceId);
            } else {
                throw new NotPermittedException();
            }
        }
        if ((finishedNode = requestNode.get("finished")) != null && !finishedNode.isNull()) {
            boolean isFinished = finishedNode.asBoolean();
            if (isFinished) {
                taskQuery.finished();
            } else {
                taskQuery.unfinished();
            }
        }
        List tasks = taskQuery.list();
        ResultListDataRepresentation result = new ResultListDataRepresentation(this.convertTaskInfoList(tasks));
        return result;
    }

    protected List<TaskRepresentation> convertTaskInfoList(List<HistoricTaskInstance> tasks) {
        ArrayList<TaskRepresentation> result = new ArrayList<TaskRepresentation>();
        if (CollectionUtils.isNotEmpty(tasks)) {
            TaskRepresentation representation = null;
            for (HistoricTaskInstance task : tasks) {
                representation = new TaskRepresentation(task);
                UserCache.CachedUser cachedUser = this.userCache.getUser(task.getAssignee());
                if (cachedUser != null && cachedUser.getUser() != null) {
                    representation.setAssignee(new UserRepresentation(cachedUser.getUser()));
                }
                result.add(representation);
            }
        }
        return result;
    }
}

