/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.activiti5.engine.impl.pvm.runtime;

import org.activiti5.engine.impl.pvm.process.ScopeImpl;


/**
 * @author Tom Baeyens
 */
public class AtomicOperationActivityStart extends AbstractEventAtomicOperation {

  @Override
  protected void eventNotificationsCompleted(InterpretableExecution execution) {
    execution.performOperation(AtomicOperation.ACTIVITY_EXECUTE);
  }

  @Override
  protected String getEventName() {
    return org.activiti5.engine.impl.pvm.PvmEvent.EVENTNAME_START;
  }

  @Override
  protected ScopeImpl getScope(InterpretableExecution execution) {
    return (ScopeImpl) execution.getActivity();
  }

}
