﻿///KSS网络验证登陆模板
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Util;

namespace 用户模式
{
    public partial class LoginForm : Form
    {
        int v_softcode = 0;
        string v_softkey = string.Empty;
        public LoginForm()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            
            ///★★★★★★此参数请查阅管理端【软件列表】里[软件编号]的值
            v_softcode = 1000101;

            ///★★★★★★此参数请查阅管理端【软件列表】里[软件密钥]的值
            v_softkey = "67iRh5471AX12K111HUHtAmK";
            
            ///下边两个参数主要用来自动调整界面上的通道控件和解绑按钮是否可见
            int v_haveclientid = 0;   ///是否有多通道卡
            int v_haveunbind = 0;   ///是否允许客户通过解绑按钮解绑
            
            ///★★★★★★配合自动更新功能，如果为0则会关闭自动更新，与ks_setUVal接口和管理端【软件参数设置】里的【自动更新】选项卡里的参数可实现自动更新软件功能
            int v_softversion = 1;

            ///★★★★★★如若你觉得验证模块取的机器码不够安全或经常变动，你可以自己写函数取机器码这个变量，要求最少五个字符，否则请留空
            string v_pccode = string.Empty;
            
            ///★★★★★★连接服务器超时默认为6000毫秒
            int v_cstime = 6000;

            ///★★★★★★如果你装有验证备服，这里请填1，否则填0
            int v_is2svr = 0;

            
            ///KS授权信息
            KssModule.ks_setLicense(Parameters.LicenseKey);
    
            /// 初始化扩展参数
            KssModule.ks_setExtVal(0, v_pccode, Parameters.v_inipath, v_cstime, v_is2svr, Parameters.v_rsamod, Parameters.v_rsapubkey, "", "", "");
            
            //Checkupdate.Value = Int("0" & r_ini("Soft_Config", "checkupdate"));
            string checkUpdate = KssModule.r_ini("Soft_Config", "checkupdate");
            this.cbCheckUpdate.Checked = Convert.ToInt32(checkUpdate == "" ? "0" : checkUpdate) != 0;
    
            //passCheck.Value = Int("0" & r_ini("Soft_Config", "Rememberaccount"));
            string rememberaccount = KssModule.r_ini("Soft_Config", "Rememberaccount");
            this.cbCheckPwd.Checked = Convert.ToInt32(rememberaccount == "" ? "0" : rememberaccount) != 0;
    
            if(this.cbCheckPwd.Checked)
            {
                this.tbUserName.Text = KssModule.r_ini("Soft_Config", "username");
                this.tbPwd.Text = KssModule.r_ini("Soft_Config", "password");
            }
                
            if(this.tbClientID.Text == "1")  ///是否有多通道卡界面控制
            {
                this.lblClientID.Visible = true;
                this.tbClientID.Visible = true;
            }
            else
            {
                this.lblClientID.Visible = false;
                this.tbClientID.Visible = false;
                this.tbClientID.Text = "1";
            }
    
            this.btnRelBind.Visible = v_haveunbind != 0;
                
            //无论调用多少次ks_GetData（参数大于10000000），只会连接一次网络（无论参数是否相同）
            //以下五行代码视你具体需求，你可以决定是否保留

            //s_isup = KssModule.ks_GetData(Convert.ToInt32(Parameters.v_softcode.ToString() + "1"));   ///服务端软件是否强制更新
            //s_version = KssModule.ks_GetData(Convert.ToInt32(Parameters.v_softcode.ToString() + "2"));  ///服务端软件版本
            //s_downurl = KssModule.ks_GetData(Convert.ToInt32(Parameters.v_softcode.ToString() + "3"));   ///服务端软件下载地址
            //s_notice = KssModule.ks_GetData(Convert.ToInt32(Parameters.v_softcode.ToString() + "4"));  ///服务端软件公告
            //essageBox.Show(s_notice);
  
        }

        /// <summary>
        /// 登陆
        /// </summary>
        private void btnLogin_Click(object sender, EventArgs e)
        {
            string tempstr = string.Empty;
            string v_msgstr, aabbcc = string.Empty;
            int i_rnd = 0;
            this.btnLogin.Enabled = false;

            ///--  传递软件相关参数给DLL
            ///--  参数：1软件编号, 2软件密钥

            KssModule.ks_setSoftVal(v_softcode, v_softkey);

            
            string v_bdinfo = string.Empty;           ///用户的绑定信息。
            ///--  传递用户相关信息给DLL
            KssModule.ks_setUserVal(Convert.ToInt32(this.tbClientID.Text), this.tbUserName.Text, this.tbPwd.Text, v_bdinfo);
                
            ///★★★★★★配合自动更新功能，如果为0则会关闭自动更新，与ks_setUVal接口和管理端【软件参数设置】里的【自动更新】选项卡里的参数可实现自动更新软件功能
            int v_softversion = 1;

            ///--  设置自动升级相关信息给DLL，不用自动升级功能的话，下边一段完全可以删掉
            ///--  参数：1本登陆窗口的窗口句柄, 2当前软件的版本号, 3用户是否选择了检查更新
            KssModule.ks_setUpVal(this.Handle.ToInt32(), v_softversion, this.cbCheckUpdate.Checked?1:0);

            ///--  开始验证   chkPass非dll接口函数，该函数在 ksregModule模块中
            
            Random random = new Random();
            i_rnd = random.Next(0, 50);

            ///取文本中间 (signData, i × 8, 8)
            v_msgstr = KssModule.ks_IdCheck(Parameters.signData.Substring(i_rnd * 8, 8), 0);

            if(KssModule.IsErrNo(v_msgstr))
            {
                MessageBox.Show(KssModule.ks_GetMsg(v_msgstr));
                this.btnLogin.Enabled = true;
            }
            
            if(v_msgstr != Parameters.signData.Substring(i_rnd * 8 + 400, 8))
            {
                KssModule.w_ini("signdata", "err", v_msgstr + "," + Parameters.signData.Substring(i_rnd * 8 + 400, 8));
            }
             
            this.btnLogin.Enabled = true;
            if(this.cbCheckPwd.Checked)
            {
                KssModule.w_ini("Soft_Config", "username", this.tbUserName.Text.Trim());
                KssModule.w_ini("Soft_Config", "password", this.tbPwd.Text.Trim());
            }
            else
            {
                KssModule.w_ini("Soft_Config", "username", "");
                KssModule.w_ini("Soft_Config", "password", "");   
            }

            ///★★★★★★如果你用IPC进程通讯模式，此参数请改为1
            int v_isipcmode = 0;
            if(v_isipcmode == 1)
            {
                IPCForm ipcForm = new IPCForm();
                ipcForm.Show();
            }
            else
            {
                YourForm1 yourForm = new YourForm1();
                yourForm.Show();
            }
            /// this.Hide();   ///隐藏登陆窗口
            /// 载入并显示你的主程序窗口,这里假设你的主窗口名为 YourForm1
        }

        /// <summary>
        /// 解绑按钮单击
        /// </summary>
        private void btnRelBind_Click(object sender, EventArgs e)
        {
            string tempstr = string.Empty;
            string userName = this.tbUserName.Text.Trim();
            string password = this.tbPwd.Text.Trim();
            if(string.IsNullOrEmpty(userName) || string.IsNullOrEmpty(password))
            {
                MessageBox.Show("请输入用户名和密码");
            }
            
            tempstr = KssModule.ks_unbind(v_softcode, Convert.ToInt32(this.tbClientID.Text.Trim()), userName, password);

            if(KssModule.IsErrNo(tempstr))
            {
                tempstr = KssModule.ks_GetMsg(tempstr);                
            }
            MessageBox.Show(tempstr);
            
        }

        /// <summary>
        /// 查询卡或用户
        /// </summary>
        private void btnSearch_Click(object sender, EventArgs e)
        {            
            string tempstr = string.Empty;
            int nkeypos = 0;
            if(this.tbSearchInfo.Text == "请输入用户名或注册卡号" || string.IsNullOrEmpty(this.tbSearchInfo.Text.Trim()))
            {
                MessageBox.Show("请输入用户名或注册卡号");
            }

            tempstr = KssModule.ks_viewinfo(v_softcode, this.tbSearchInfo.Text.Trim());     // 查询
    
            /// 以下三行用来处理旧卡号
            nkeypos = tempstr.IndexOf("《");
            if(nkeypos > 0)
            {
                this.tbSearchInfo.Text = tempstr.Substring(nkeypos + 1, 32);       
            }            
            if(KssModule.IsErrNo(tempstr))
            {
                tempstr = KssModule.ks_GetMsg(tempstr);                
            }
            MessageBox.Show(tempstr);
        }

        private void tbSearchInfo_Click(object sender, EventArgs e)
        {
            if(this.tbSearchInfo.Text == "请输入用户名或注册卡号")
            {
                this.tbSearchInfo.Text = "";
            }
            this.tbSearchInfo.ForeColor = Color.Black;
        }

        private void cbCheckUpdate_Click(object sender, EventArgs e)
        {
            KssModule.w_ini("Soft_Config", "checkupdate", this.cbCheckUpdate.Checked ? "1" : "0");
        }

        private void cbCheckPwd_Click(object sender, EventArgs e)
        {
            KssModule.w_ini("Soft_Config", "Rememberaccount", this.cbCheckPwd.Checked ? "1" : "0");
        }
               
        /// <summary>
        /// 注册帐号和充值功能
        /// </summary>
        private void btnReg_Click(object sender, EventArgs e)
        {
            string tempStr = string.Empty;
            if(rbReg.Checked)
            {
                tempStr = KssModule.ks_reguser(v_softcode, this.tbUserName2.Text.Trim(), this.tbPwd2.Text.Trim(), this.tbSuperPwd2.Text.Trim(),
                    this.tbRecharge2.Text.Trim(), this.tbBindInfo2.Text.Trim(), this.tbPromote2.Text.Trim());
            }
            else
            {
                tempStr = KssModule.ks_prepaid(v_softcode, this.tbUserName2.Text.Trim(), this.tbRecharge2.Text.Trim());
            }
            if(KssModule.IsErrNo(tempStr))
            {
                tempStr = KssModule.ks_GetMsg(tempStr);                
            }
            MessageBox.Show(tempStr);

        }

        private void radioButton1_CheckedChanged(object sender, EventArgs e)
        {
            if (rbReg.Checked) 
            {
                rbRecharge.Checked = false;
                this.btnReg.Text = "注册账号";
            }
        }

        private void radioButton2_CheckedChanged(object sender, EventArgs e)
        {
            if (rbRecharge.Checked)
            {
                rbReg.Checked = false;
                this.btnReg.Text = "充值";
            }

        }

        /// <summary>
        /// 修改用户资料按钮单击事件
        /// </summary>
        private void btnUpdate_Click(object sender, EventArgs e)
        {
            string tempStr = string.Empty;
            tempStr = KssModule.ks_edit(v_softcode, this.tbUserName3.Text.Trim(), this.tbSuperPwd3.Text.Trim(), 
                this.tbPwd3.Text.Trim(), this.tbBindInfo3.Text.Trim());
                
            if(KssModule.IsErrNo(tempStr))
            {
                tempStr = KssModule.ks_GetMsg(tempStr);                
            }
            MessageBox.Show(tempStr);
        }

        /// <summary>
        /// 当在输入充值卡的控件上单击时，弹出一个多功能的卡号输入窗口
        /// </summary>
        private void tbRecharge2_Click(object sender, EventArgs e)
        {
            InputKeyForm keyForm = new InputKeyForm(this, this.tbRecharge2.Text.Trim());
            keyForm.ShowDialog();
        }
        
    }
}
