﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Util;

namespace 卡号模式
{
    public partial class LoginForm : Form
    {
        int v_softcode = 0;
        string v_softkey = string.Empty;
        public LoginForm()
        {
            InitializeComponent();
        }

        private void LoginForm_Load(object sender, EventArgs e)
        {
            
            /// ★★★★★★此参数请查阅管理端【软件列表】里[软件编号]的值
            v_softcode = 1000102;
    
            /// ★★★★★★此参数请查阅管理端【软件列表】里[软件密钥]的值
            v_softkey = "IpG971PHDj2psv4TX2SlL247";

            ///下边两个参数主要用来自动调整界面上的通道控件和解绑按钮是否可见
            int v_haveclientid = 0;   ///是否有多通道卡
            int v_haveunbind = 0;   ///是否允许客户通过解绑按钮解绑

            ///★★★★★★配合自动更新功能，如果为0则会关闭自动更新，与ks_setUVal接口和管理端【软件参数设置】里的【自动更新】选项卡里的参数可实现自动更新软件功能
            int v_softversion = 1;

            ///★★★★★★如若你觉得验证模块取的机器码不够安全或经常变动，你可以自己写函数取机器码这个变量，要求最少五个字符，否则请留空
            string v_pccode = string.Empty;

            ///★★★★★★连接服务器超时默认为6000毫秒
            int v_cstime = 6000;

            ///★★★★★★如果你装有验证备服，这里请填1，否则填0
            int v_is2svr = 0;


            ///KS授权信息
            KssModule.ks_setLicense(Parameters.LicenseKey);

            /// 初始化扩展参数
            KssModule.ks_setExtVal(0, v_pccode, Parameters.v_inipath, v_cstime, v_is2svr, Parameters.v_rsamod, Parameters.v_rsapubkey, "", "", "");

            //Checkupdate.Value = Int("0" & r_ini("Soft_Config", "checkupdate"));
            string checkUpdate = KssModule.r_ini("Soft_Config", "checkupdate");
            this.cbCheckUpdate.Checked = Convert.ToInt32(checkUpdate == "" ? "0" : checkUpdate) != 0;

            //passCheck.Value = Int("0" & r_ini("Soft_Config", "Rememberaccount"));
            string rememberaccount = KssModule.r_ini("Soft_Config", "Rememberaccount");
            this.cbCheckCardNum.Checked = Convert.ToInt32(rememberaccount == "" ? "0" : rememberaccount) != 0;

            if (this.cbCheckCardNum.Checked)
            {
                this.tbCardNum.Text = KssModule.r_ini("Soft_Config", "card");
            }

            if (v_haveclientid != 1)  ///是否有多通道卡界面控制
            {
                this.lblClientID.Visible = true;
                this.tbClientID.Visible = true;
            }

            this.btnRelBind.Visible = v_haveunbind != 0;

            //无论调用多少次ks_GetData（参数大于10000000），只会连接一次网络（无论参数是否相同）
            //以下五行代码视你具体需求，你可以决定是否保留

            //s_isup = KssModule.ks_GetData(Convert.ToInt32(Parameters.v_softcode.ToString() + "1"));   ///服务端软件是否强制更新
            //s_version = KssModule.ks_GetData(Convert.ToInt32(Parameters.v_softcode.ToString() + "2"));  ///服务端软件版本
            //s_downurl = KssModule.ks_GetData(Convert.ToInt32(Parameters.v_softcode.ToString() + "3"));   ///服务端软件下载地址
            //s_notice = KssModule.ks_GetData(Convert.ToInt32(Parameters.v_softcode.ToString() + "4"));  ///服务端软件公告
            //essageBox.Show(s_notice);
        }

        private void btnLogin_Click(object sender, EventArgs e)
        {
            string tempstr = string.Empty;
            string v_msgstr, aabbcc = string.Empty;
            int i_rnd = 0;
            this.btnLogin.Enabled = false;

            ///--  传递软件相关参数给DLL
            ///--  参数：1软件编号, 2软件密钥

            KssModule.ks_setSoftVal(v_softcode, v_softkey);


            string v_bdinfo = string.Empty;           ///用户的绑定信息。
            ///--  传递用户相关信息给DLL
            KssModule.ks_setUserVal(Convert.ToInt32(this.tbClientID.Text), this.tbCardNum.Text, "", v_bdinfo);

            ///★★★★★★配合自动更新功能，如果为0则会关闭自动更新，与ks_setUVal接口和管理端【软件参数设置】里的【自动更新】选项卡里的参数可实现自动更新软件功能
            int v_softversion = 1;

            ///--  设置自动升级相关信息给DLL，不用自动升级功能的话，下边一段完全可以删掉
            ///--  参数：1本登陆窗口的窗口句柄, 2当前软件的版本号, 3用户是否选择了检查更新
            KssModule.ks_setUpVal(this.Handle.ToInt32(), v_softversion, this.cbCheckUpdate.Checked ? 1 : 0);

            ///--  开始验证   chkPass非dll接口函数，该函数在 ksregModule模块中

            Random random = new Random();
            i_rnd = random.Next(0, 50);

            ///取文本中间 (signData, i × 8, 8)
            v_msgstr = KssModule.ks_IdCheck(Parameters.signData.Substring(i_rnd * 8, 8), 0);

            if (KssModule.IsErrNo(v_msgstr))
            {
                MessageBox.Show(KssModule.ks_GetMsg(v_msgstr));
                this.btnLogin.Enabled = true;
            }

            if (v_msgstr != Parameters.signData.Substring(i_rnd * 8 + 400, 8))
            {
                KssModule.w_ini("signdata", "err", v_msgstr + "," + Parameters.signData.Substring(i_rnd * 8 + 400, 8));
            }

            this.btnLogin.Enabled = true;
            if (this.cbCheckCardNum.Checked)
            {
                KssModule.w_ini("Soft_Config", "card", this.tbCardNum.Text.Trim());
            }
            else
            {
                KssModule.w_ini("Soft_Config", "card", "");
            }

            ///★★★★★★如果你用IPC进程通讯模式，此参数请改为1
            int v_isipcmode = 0;
            if (v_isipcmode == 1)
            {
                IPCForm ipcForm = new IPCForm();
                ipcForm.Show();
            }
            else
            {
                YourForm1 yourForm = new YourForm1();
                yourForm.Show();
            }
            /// this.Hide();   ///隐藏登陆窗口
            ///载入并显示你的主程序窗口,这里假设你的主窗口名为 YourForm1
        }

        private void tbCardNum_Click(object sender, EventArgs e)
        {
            if (this.tbCardNum.Text == "请输入注册卡号")
            {
                this.tbCardNum.Text = "";
            }
            this.tbCardNum.ForeColor = Color.Black;
        }

        private void cbCheckCardNum_Click(object sender, EventArgs e)
        {
            KssModule.w_ini("Soft_Config", "Rememberaccount", this.cbCheckCardNum.Checked ? "1" : "0");
        }

        private void cbCheckUpdate_Click(object sender, EventArgs e)
        {
            KssModule.w_ini("Soft_Config", "checkupdate", this.cbCheckUpdate.Checked ? "1" : "0");
        }

        /// <summary>
        /// 解绑按钮单击
        /// </summary>
        private void btnRelBind_Click(object sender, EventArgs e)
        {
            string tempstr = string.Empty;
            string cardNum = this.tbCardNum.Text.Trim();
            if (string.IsNullOrEmpty(cardNum))
            {
                MessageBox.Show("请输入注册卡号");
            }

            tempstr = KssModule.ks_unbind(v_softcode, Convert.ToInt32(this.tbClientID.Text.Trim()), cardNum, "");

            if (KssModule.IsErrNo(tempstr))
            {
                tempstr = KssModule.ks_GetMsg(tempstr);
            }
            MessageBox.Show(tempstr);
        }

        /// <summary>
        /// 查询卡或用户
        /// </summary>
        private void btnSearch_Click(object sender, EventArgs e)
        {
            string tempstr = string.Empty;
            int nkeypos = 0;
            if (this.tbCardNum.Text == "请输入注册卡号" || string.IsNullOrEmpty(this.tbCardNum.Text.Trim()))
            {
                MessageBox.Show("请输入注册卡号");
            }

            tempstr = KssModule.ks_viewinfo(v_softcode, this.tbCardNum.Text.Trim());     // 查询

            /// 以下三行用来处理旧卡号
            nkeypos = tempstr.IndexOf("《");
            if (nkeypos > 0)
            {
                this.tbCardNum.Text = tempstr.Substring(nkeypos + 1, 32);
            }
            if (KssModule.IsErrNo(tempstr))
            {
                tempstr = KssModule.ks_GetMsg(tempstr);
            }
            MessageBox.Show(tempstr);
        }

        /// <summary>
        /// 修改用户绑定信息按钮单击事件
        /// </summary>
        private void btnks_editbtn_Click(object sender, EventArgs e)
        {
            string tempStr = string.Empty;
            tempStr = KssModule.ks_edit(v_softcode, this.tbCardNum.Text.Trim(), "", "", this.tbBindInfo.Text.Trim());
                        
            if (KssModule.IsErrNo(tempStr))
            {
                tempStr = KssModule.ks_GetMsg(tempStr);
            }
            MessageBox.Show(tempStr);
        }
    }
}
