# 文件结构

小程序包含一个描述整体程序的 app 和多个描述各自页面的 page。一个小程序主体部分由三个文件组成，必须放在项目的根目录，如下：

| 文件 |	必须 |	作用 |
| ----- | ----- | ----- |
| app.js |	是 |	小程序逻辑 |
| app.json |	是 |	小程序公共配置 |
| app.wxss |	否 |	小程序公共样式表 |

一个小程序页面由四个文件组成，分别是：

| 文件 |	必须 |	作用 |
| ----- | ----- | ----- |
| 页面名.js |	是 |	页面逻辑 |
| 页面名.wxml |	是 |	界面布局文件 |
| 页面名.wxss |	否 |	页面样式表 |
| 页面名.json |	否 |	页面配置 |

注意：这四个文件的**页面名**必须具有相同的路径与文件名。

*（小安娜：js & json我认识，wxml、wxss是什么鬼，地球上从未见过的格式！）*

# 配置

我们使用`app.json`文件来对微信小程序进行全局配置，决定页面文件的路径、窗口表现、设置网络超时时间、设置多 tab 等。以下是一个包含了所有配置选项的简单配置`app.json`：

*（小安娜：app.json，我可以改成abc.json不？）*

```javascript
{
  "pages":[
    "pages/index/index"
  ],
  "window":{
    "backgroundTextStyle": "light",
    "navigationBarBackgroundColor": "#fff",
    "navigationBarTitleText": "哔哩哔哩弹幕视频网",
    "navigationBarTextStyle": "black",
    "backgroundColor": "#f4f4f4"
  },
  "debug": true
}
```

*（小安娜：#fff是什么意思？我只知道FFF团！）*，#fff代表HexColor十六进制颜色值。*（小安娜：我不管这些，我只想知道这个值是怎么来的？）*，小安娜你是刁难我的吧，这个是设计上的问题，开发前可让设计师标注下界面的颜色值，或者看到喜欢的颜色也可用屏幕颜色拾取工具获取。

## app.json 配置项列表

| 文件 |	类型 |	必须 |	作用 |
| ----- | ----- | ----- | ----- |
| pages |	String Array |	是 |	设置页面路径集合 |
| window |	Object |	否 |	设置默认页面的窗口表现 |
| tabBar |	Object |	否 |	设置底部 tab 的表现 |
| networkTimeout |	Object |	否 |	设置网络超时时间 |
| debug |	Boolean |	否 |	设置是否开启 debug 模式 |

## pages

接受一个数组，每一项都是字符串，来指定小程序由哪些页面组成。每一项代表对应页面的【路径+文件名】，**数组的第一项代表小程序的初始页面。小程序中新增/减少页面，都需要对 pages 数组进行修改**。

文件名不需要写后缀，框架会自动寻找路径`.json`、`.js`、`.wxml`、`.wxss`四个文件进行整合。

*（小安娜：不是很明白这段话，什么鬼自动寻找路径，四个文件进行整合）*

如开发目录为：

- pages/
- |\-- pages/index/index.wxml
- |\-- pages/index/index.js
- |\-- pages/index/index.wxss
- app.js
- app.json
- app.wxss

则，我们只需要在 `app.json` 中写：  
（pages/index/index不需要添加后缀）

```javascript
{
  "pages":[
    "pages/index/index"
  ]
}
```

### window

用于设置小程序的状态栏、导航条、标题、窗口背景色。

| 属性 |	类型 |	默认值 |	描述 |
| ----- | ----- | ----- | ----- |
| navigationBarBackgroundColor |	HexColor |	是 |	导航栏背景颜色，如"#000000" |
| navigationBarTextStyle |	String |	#000000 |	导航栏标题颜色，仅支持 black/white |
| navigationBarTitleText |	String |	white |	导航栏标题文字内容 |
| backgroundColor |	HexColor |	#ffffff |	窗口的背景色 |
| backgroundTextStyle |	String |	dark |	下拉背景字体、loading 图的样式，仅支持 dark/light|
| enablePullDownRefresh |	Boolean |	false |	是否开启下拉刷新 |

如 `app.json` ：

```javascript
{
  "window":{
    "backgroundTextStyle": "light",
    "navigationBarBackgroundColor": "#fff",
    "navigationBarTitleText": "哔哩哔哩弹幕视频网",
    "navigationBarTextStyle": "black",
    "backgroundColor": "#f4f4f4"
  }
}
```

### tabBar

由于本项目中未用到tabBar就不耽误大家的时间了，如需要了解见官方文档：https://mp.weixin.qq.com/debug/wxadoc/dev/framework/config.html#tabbar

*（小安娜：tabBar是客户端窗口底部的tab栏可以切换页面，可配置最少2个、最多5个 tab，不要感谢我，记得我是雷锋就行）*，噗~，这都行！

## networkTimeout

可以设置各种网络请求的超时时间。

| 属性 |	类型 |	必填 |	说明 |
| ----- | ----- | ----- | ----- |
| request |	Number |	否 |	`wx.request`的超时时间，单位毫秒 |
| connectSocket |	Number |	否 |	`wx.connectSocket`的超时时间，单位毫秒 |
| uploadFile |	Number |	否 |	`wx.uploadFile`的超时时间，单位毫秒 |
| downloadFile |	Number |	否 |	`wx.downloadFile`的超时时间，单位毫秒 |

*（小安娜：`wx.request`、`wx.connectSocket`、`wx.uploadFile`、`wx.downloadFile`这些又是什么？）*，wx.request：发起网络请求，wx.connectSocket：创建 WebSocket 连接，wx.uploadFile：上传文件，wx.downloadFile：下载文件，这些API先简单有个印象，文章会陆续用上详细介绍。

## debug

可以在开发者工具中开启 debug 模式，在开发者工具的控制台面板*（小安娜：控制台面板在哪？）*，调试信息以 info 的形式给出，其信息有Page的注册，页面路由，数据更新，事件触发 。 可以帮助开发者快速定位一些常见的问题。

![控制台面板](http://ctt.jieerf.com/wp-content/uploads/2016/11/debug.jpg)

*（小安娜：你有没有debug模式啊，让我开启就能知道你所有的秘密，微信支付、支付宝、银行卡密码...嘻嘻坏笑~）*

## 所以最终app.json是这样的

```javascript
{
  "pages":[
    "pages/index/index"
  ],
  "window":{
    "backgroundTextStyle": "light",
    "navigationBarBackgroundColor": "#fff",
    "navigationBarTitleText": "哔哩哔哩弹幕视频网",
    "navigationBarTextStyle": "black",
    "backgroundColor": "#f4f4f4"
  },
  "debug": true
}
```

# 小安娜有问题

## app.json我可以随便改成abc.json吗？

**杰尔夫君：**不可以，`app.js`、`app.json`、`app.wxss`微信小程序会读取这些文件，并生成小程序实例，任何一个文件名都不可以改动。

## wxml、wxss文件格式是什么？

杰尔夫君：WXML（WeiXin Markup Language）是微信框架设计的一套标签语言，结合基础组件、事件系统，可以构建出页面的结构。WXSS(WeiXin Style Sheets)是一套样式语言，用于描述 WXML 的组件样式，与CSS类似，也具有CSS大部分特性。这2个文件具体会在下一篇文章详细讲解。